//   ===============================================================================================
//   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// -------------------------------------------------------------------------------------------------
//   Copyright (c) 2021 by Lattice Semiconductor Corporation
// -------------------------------------------------------------------------------------------------
//
// Permission:
//
//   Lattice Semiconductor grants permission to use this code for use in synthesis for any Lattice 
//   programmable logic product.  Other use of this code, including the selling or duplication of 
//   any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL or Verilog source code is intended as a design reference which illustrates how these
//   types of functions can be implemented.  It is the user's responsibility to verify their design
//   for consistency and functionality through the use of formal verification methods.  Lattice 
//   Semiconductor provides no warranty regarding the use or functionality of this code.
//
// -------------------------------------------------------------------------------------------------
//
//                               Lattice Semiconductor Corporation
//                               5555 NE Moore Court
//                               Hillsboro, OR 97214
//                               U.S.A
//                            
//                               TEL: 1-800-Lattice (USA and Canada)
//                                    408-826-6000 (other locations)
//                            
//                               web: http://www.latticesemi.com/
//                               email: techsupport@latticesemi.com
//
// -------------------------------------------------------------------------------------------------
// Filename        : tb_top.v
// Description     : simple testbench
// Created On      : 2021
// Revision        : Revision: 1.00 
// ------------------------------------------------------------------------------------------------
`timescale 1 ns / 1 ps

module tb_top;

  parameter CLOCK_CYCLE = 50;
  wire [31:0] countt;
  reg 	clk, rstn, direction; 


  top dut(	
  .rstn			(~rstn),
  .clk			(clk),
  .count		(countt),
  .lock			(lock),
  .direction	(direction)
  );

  initial begin
	clk = 1'b1;
	rstn = 1'b1;
	direction = 1'b1;
  end

  GSR GSR_INST (	
  .GSR_N (1'b0),  // I
  .CLK   (clk)   // I
  );

  always
	#(CLOCK_CYCLE/2.0) clk = ~clk;

  initial begin		
	#(0.3*CLOCK_CYCLE);
	#(10*CLOCK_CYCLE) rstn = 1'b0;	
	
	
	#(5000*CLOCK_CYCLE) $stop;
  end

endmodule